/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Wrapper;
import oracle.jdbc.driver.json.JakartaExceptionFactory;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JakartaPrimitive {
    private static boolean stringsEqual(JsonString jsonString, Object object) {
        if (!(object instanceof JsonString)) {
            return false;
        }
        return jsonString == object || jsonString.getString().equals(((JsonString)object).getString());
    }

    private JakartaPrimitive() {
    }

    private static interface DefaultJsonString
    extends JsonString,
    Wrapper {
        default public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.STRING;
        }

        public OracleJsonValue getUnwrapped();

        @Override
        default public <T> T unwrap(Class<T> clazz) throws SQLException {
            OracleJsonValue oracleJsonValue = this.getUnwrapped();
            if (clazz.isInstance(oracleJsonValue)) {
                return (T)oracleJsonValue;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, clazz.getName()).getMessage());
        }

        @Override
        default public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return clazz.isInstance(this.getUnwrapped());
        }

        default public CharSequence getChars() {
            return this.getString();
        }
    }

    private static abstract class DefaultJsonNumber
    extends OracleJsonNumberImpl
    implements JsonNumber,
    Wrapper {
        private DefaultJsonNumber() {
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.NUMBER;
        }

        abstract OracleJsonValue getUnwrapped();

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            OracleJsonValue oracleJsonValue = this.getUnwrapped();
            if (clazz.isInstance(oracleJsonValue)) {
                return (T)oracleJsonValue;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, clazz.getName()).getMessage());
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return clazz.isInstance(this.getUnwrapped());
        }

        @Override
        public String getString() {
            try {
                return ((OracleJsonNumberImpl)((Object)this.unwrap(OracleJsonNumber.class))).getString();
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException();
            }
        }

        public final boolean equals(Object object) {
            if (!(object instanceof JsonNumber)) {
                return false;
            }
            return this.bigDecimalValue().equals(((JsonNumber)object).bigDecimalValue());
        }

        public final int hashCode() {
            return this.bigDecimalValue().hashCode();
        }
    }

    public static class JakartaStringNumberImpl
    extends DefaultJsonNumber {
        private String value;

        public JakartaStringNumberImpl(String string) {
            this.value = string;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return new BigDecimal(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringNumberImpl(this.value);
        }
    }

    public static class JakartaIntervalYMImpl
    implements DefaultJsonString {
        byte[] raw;

        public JakartaIntervalYMImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalYM(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalYMImpl(this.raw);
        }
    }

    public static class JakartaIntervalDSImpl
    implements DefaultJsonString {
        private byte[] raw;

        public JakartaIntervalDSImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalDS(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalDSImpl(this.raw);
        }
    }

    public static class JakartaTimestampTZImpl
    implements DefaultJsonString {
        private byte[] raw;

        public JakartaTimestampTZImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.timestampTZToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonTimestampTZImpl(this.raw);
        }
    }

    public static class JakartaTimestampImpl
    implements DefaultJsonString {
        private byte[] raw;

        public JakartaTimestampImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.timestampToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonTimestampImpl(this.raw);
        }
    }

    public static class JakartaDateImpl
    implements DefaultJsonString {
        byte[] raw;

        public JakartaDateImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.dateToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDateImpl(this.raw);
        }
    }

    public static class JakartaBinaryImpl
    implements DefaultJsonString {
        byte[] bytes;
        boolean isId;

        public JakartaBinaryImpl(byte[] byArray, boolean bl) {
            this.bytes = byArray;
            this.isId = bl;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonBinaryImpl(this.bytes, this.isId);
        }
    }

    public static class JakartaStringImpl
    implements DefaultJsonString {
        String value;

        public JakartaStringImpl(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            return JakartaPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String getString() {
            return this.value;
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringImpl(this.value);
        }
    }

    public static class JakartaDoubleImpl
    extends DefaultJsonNumber {
        double value;

        public JakartaDoubleImpl(double d2) {
            this.value = d2;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDoubleImpl(this.value);
        }
    }

    public static class JakartaFloatImpl
    extends DefaultJsonNumber {
        private float value;

        public JakartaFloatImpl(float f2) {
            this.value = f2;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonFloatImpl(this.value);
        }
    }

    public static class JakartaNumberImpl
    extends DefaultJsonNumber {
        byte[] raw;
        OracleJsonDecimal.TargetType type;

        public JakartaNumberImpl(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
            this.raw = byArray;
            this.type = targetType;
        }

        @Override
        public final BigDecimal bigDecimalValue() {
            return OsonPrimitiveConversions.toBigDecimal(this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDecimalImpl(this.raw, this.type);
        }
    }
}

