/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.BLOB;

public class OracleBlobOutputStream
extends OutputStream {
    long lobOffset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:37_PDT_2010";

    public OracleBlobOutputStream(BLOB bLOB, int n) throws SQLException {
        this(bLOB, n, 1L);
    }

    public OracleBlobOutputStream(BLOB bLOB, int n, long l) throws SQLException {
        if (bLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = bLOB;
        this.lobOffset = l;
        this.buf = new byte[n];
        this.count = 0;
        this.bufSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, this.buf, 0, this.count);
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n;
        int n4 = Math.min(n2, byArray.length - n);
        if (n4 >= 2 * this.bufSize) {
            if (this.count > 0) {
                this.flushBuffer();
            }
            try {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, byArray, n, n4);
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        } else {
            int n5 = n3 + n4;
            while (n3 < n5) {
                int n6 = Math.min(this.bufSize - this.count, n5 - n3);
                System.arraycopy(byArray, n3, this.buf, this.count, n6);
                n3 += n6;
                this.count += n6;
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
        }
    }
}

