/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CLOB;

public class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    CLOB clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:38_PDT_2010";

    public OracleClobOutputStream(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (cLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.clob = cLOB;
        this.lobOffset = l;
        this.buf = new byte[n];
        this.count = 0;
        this.bufSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                char[] cArray = new char[this.count];
                int n = 0;
                while (n < this.count) {
                    cArray[n] = (char)this.buf[n];
                    ++n;
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray);
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n;
        int n4 = Math.min(n2, byArray.length - n);
        if (n4 >= 2 * this.bufSize) {
            if (this.count > 0) {
                this.flushBuffer();
            }
            try {
                char[] cArray = new char[n4];
                int n5 = 0;
                while (n5 < n4) {
                    cArray[n5] = (char)byArray[n5 + n];
                    ++n5;
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray);
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
            return;
        }
        int n6 = n3 + n4;
        while (n3 < n6) {
            int n7 = Math.min(this.bufSize - this.count, n6 - n3);
            System.arraycopy(byArray, n3, this.buf, this.count, n7);
            n3 += n7;
            this.count += n7;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }
}

