/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:18_PDT_2010";

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int n) {
        super(n);
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n2 = (int)(n == -1 ? (long)sArray.length : Math.min((long)sArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                int n3 = 0;
                while (n3 < n2) {
                    datumArray[n3] = new NUMBER(sArray[(int)l + n3 - 1]);
                    ++n3;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n4 = (int)(n == -1 ? (long)nArray.length : Math.min((long)nArray.length - l + 1L, (long)n));
                datumArray = new Datum[n4];
                int n5 = 0;
                while (n5 < n4) {
                    datumArray[n5] = new NUMBER(nArray[(int)l + n5 - 1]);
                    ++n5;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n6 = (int)(n == -1 ? (long)lArray.length : Math.min((long)lArray.length - l + 1L, (long)n));
                datumArray = new Datum[n6];
                int n7 = 0;
                while (n7 < n6) {
                    datumArray[n7] = new NUMBER(lArray[(int)l + n7 - 1]);
                    ++n7;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n8 = (int)(n == -1 ? (long)fArray.length : Math.min((long)fArray.length - l + 1L, (long)n));
                datumArray = new Datum[n8];
                int n9 = 0;
                while (n9 < n8) {
                    datumArray[n9] = new NUMBER(fArray[(int)l + n9 - 1]);
                    ++n9;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n10 = (int)(n == -1 ? (long)dArray.length : Math.min((long)dArray.length - l + 1L, (long)n));
                datumArray = new Datum[n10];
                int n11 = 0;
                while (n11 < n10) {
                    datumArray[n11] = new NUMBER(dArray[(int)l + n11 - 1]);
                    ++n11;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n12 = (int)(n == -1 ? (long)blArray.length : Math.min((long)blArray.length - l + 1L, (long)n));
                datumArray = new Datum[n12];
                int n13 = 0;
                while (n13 < n12) {
                    datumArray[n13] = new NUMBER(new Boolean(blArray[(int)l + n13 - 1]));
                    ++n13;
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n14 = (int)(n == -1 ? (long)cArray.length : Math.min((long)cArray.length - l + 1L, (long)n));
                datumArray = new Datum[n14];
                int n15 = 0;
                while (n15 < n14) {
                    datumArray[n15] = new NUMBER(new String(cArray[(int)l + n15 - 1]));
                    ++n15;
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 12);
            this.alignForLds = Util.fdoGetAlign(byArray, 12);
        }
        return this.alignForLds;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 12);
            this.alignForLds = Util.fdoGetAlign(byArray, 12);
        }
        return this.sizeForLds;
    }

    protected static Object numericUnpickle80rec(int n, int n2, UnpickleContext unpickleContext, int n3, int n4, Map map) throws SQLException {
        switch (n3) {
            case 1: {
                if (unpickleContext.isNull(n2)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[n]);
                break;
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) != 1) break;
                unpickleContext.skipBytes(22);
                return null;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + n3);
            }
            case 3: 
        }
        if (n4 == 9) {
            unpickleContext.skipBytes(22);
            return null;
        }
        return OracleTypeNUMBER.toNumericObject(unpickleContext.readVarNumBytes(), n4, map);
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.nullOffset = tDSReader.nullOffset++;
        this.ldsOffset = tDSReader.ldsOffset++;
        this.precision = tDSReader.readUnsignedByte();
        this.scale = tDSReader.readByte();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scale = objectInputStream.readInt();
        this.precision = objectInputStream.readInt();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l, n);
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER;
        block3: {
            nUMBER = null;
            if (object == null) break block3;
            try {
                if (object instanceof NUMBER) {
                    nUMBER = (NUMBER)object;
                    break block3;
                }
                nUMBER = new NUMBER(object);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                int n2 = (int)(n == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                int n3 = 0;
                while (n3 < n2) {
                    datumArray[n3] = OracleTypeNUMBER.toNUMBER(objectArray[(int)l + n3 - 1], oracleConnection);
                    ++n3;
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection, l, n);
            }
        }
        return datumArray;
    }

    static Object toNumericObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new NUMBER(byArray);
            }
            case 2: {
                return NUMBER.toBigDecimal(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n, map);
    }

    protected static Object unpickle80NativeArray(UnpickleContext unpickleContext, long l, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        switch (n3) {
            case 2: {
                n4 = 23;
                break;
            }
            case 3: {
                n4 = 22;
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + n3);
            }
        }
        if (n > 0) {
            unpickleContext.skipBytes(n4 * ((int)l - 1));
        }
        int n5 = unpickleContext.absoluteOffset();
        byte[] byArray = unpickleContext.image();
        int n6 = 0;
        switch (n2) {
            case 4: {
                int[] nArray = new int[n];
                int n7 = 0;
                while (n7 < n) {
                    n6 = n5 + n7 * n4;
                    if (n3 == 3 || (byArray[n6++] & 1) == 0) {
                        byte[] byArray2 = new byte[byArray[n6++]];
                        System.arraycopy(byArray, n6, byArray2, 0, byArray2.length);
                        nArray[n7] = NUMBER.toInt(byArray2);
                    }
                    ++n7;
                }
                unpickleContext.skipBytes(n4 * n);
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n];
                int n8 = 0;
                while (n8 < n) {
                    n6 = n5 + n8 * n4;
                    if (n3 == 3 || (byArray[n6++] & 1) == 0) {
                        byte[] byArray3 = new byte[byArray[n6++]];
                        System.arraycopy(byArray, n6, byArray3, 0, byArray3.length);
                        dArray[n8] = NUMBER.toDouble(byArray3);
                    }
                    ++n8;
                }
                unpickleContext.skipBytes(n4 * n);
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n];
                int n9 = 0;
                while (n9 < n) {
                    n6 = n5 + n9 * n4;
                    if (n3 == 3 || (byArray[n6++] & 1) == 0) {
                        byte[] byArray4 = new byte[byArray[n6++]];
                        System.arraycopy(byArray, n6, byArray4, 0, byArray4.length);
                        lArray[n9] = NUMBER.toLong(byArray4);
                    }
                    ++n9;
                }
                unpickleContext.skipBytes(n4 * n);
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n];
                int n10 = 0;
                while (n10 < n) {
                    n6 = n5 + n10 * n4;
                    if (n3 == 3 || (byArray[n6++] & 1) == 0) {
                        byte[] byArray5 = new byte[byArray[n6++]];
                        System.arraycopy(byArray, n6, byArray5, 0, byArray5.length);
                        fArray[n10] = NUMBER.toFloat(byArray5);
                    }
                    ++n10;
                }
                unpickleContext.skipBytes(n4 * n);
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n];
                int n11 = 0;
                while (n11 < n) {
                    n6 = n5 + n11 * n4;
                    if (n3 == 3 || (byArray[n6++] & 1) == 0) {
                        byte[] byArray6 = new byte[byArray[n6++]];
                        System.arraycopy(byArray, n6, byArray6, 0, byArray6.length);
                        sArray[n11] = NUMBER.toShort(byArray6);
                    }
                    ++n11;
                }
                unpickleContext.skipBytes(n4 * n);
                return sArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.ldsOffset, this.nullOffset, unpickleContext, n, n2, map);
    }

    protected static Object unpickle81NativeArray(PickleContext pickleContext, long l, int n, int n2) throws SQLException {
        int n3 = 1;
        while ((long)n3 < l && n > 0) {
            pickleContext.skipDataValue();
            ++n3;
        }
        byte[] byArray = null;
        switch (n2) {
            case 4: {
                int[] nArray = new int[n];
                int n4 = 0;
                while (n4 < n) {
                    byArray = pickleContext.readDataValue();
                    if (byArray != null) {
                        nArray[n4] = NUMBER.toInt(byArray);
                    }
                    ++n4;
                }
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n];
                int n5 = 0;
                while (n5 < n) {
                    byArray = pickleContext.readDataValue();
                    if (byArray != null) {
                        dArray[n5] = NUMBER.toDouble(byArray);
                    }
                    ++n5;
                }
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n];
                int n6 = 0;
                while (n6 < n) {
                    byArray = pickleContext.readDataValue();
                    if (byArray != null) {
                        lArray[n6] = NUMBER.toLong(byArray);
                    }
                    ++n6;
                }
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n];
                int n7 = 0;
                while (n7 < n) {
                    byArray = pickleContext.readDataValue();
                    if (byArray != null) {
                        fArray[n7] = NUMBER.toFloat(byArray);
                    }
                    ++n7;
                }
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n];
                int n8 = 0;
                while (n8 < n) {
                    byArray = pickleContext.readDataValue();
                    if (byArray != null) {
                        sArray[n8] = NUMBER.toShort(byArray);
                    }
                    ++n8;
                }
                return sArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.scale);
        objectOutputStream.writeInt(this.precision);
    }
}

