/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:27:00_PDT_2010";

    public OracleXAHeteroResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    private void checkStatus(int n) throws XAException {
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = bl ? 0x40000000 : 0;
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.doXaCommit(n2, byArray, byArray2, this.rmid, n, 0);
        this.checkStatus(n3);
    }

    private native int doXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    public void end(Xid xid, int n) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            int n2 = 638582786;
            if ((n & n2) != n) {
                throw new XAException(-5);
            }
            int n3 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            this.exitGlobalTxnMode();
            int n4 = this.doXaEnd(n3, byArray, byArray2, this.rmid, n, 0);
            this.checkStatus(n4);
        }
        finally {
            Object var4_8 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.doXaForget(n, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n2);
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        byte[] byArray;
        byte[] byArray2;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        int n2 = this.doXaPrepare(n, byArray2 = xid.getGlobalTransactionId(), byArray = xid.getBranchQualifier(), this.rmid, 0, 0);
        if (n2 != 0 && n2 != 3) {
            this.checkStatus(n2);
        }
        return n2;
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.doXaRollback(n, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n2);
    }

    synchronized void setRmid(int n) {
        this.rmid = n;
    }

    public void start(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = n & 0xFF00;
        if (((n &= 0xFFFF00FF) & 0x8200002) != n) {
            throw new XAException(-5);
        }
        if ((n2 & 0xFF00) != 0 && n2 != 256 && n2 != 512 && n2 != 1024) {
            throw new XAException(-5);
        }
        if ((n2 & 0xFF00) != 0 && (n & 0x8200000) != 0) {
            throw new XAException(-5);
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int n3 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n4 = this.doXaStart(n3, byArray, byArray2, this.rmid, n |= n2, 0);
            this.checkStatus(n4);
            this.enterGlobalTxnMode();
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }
}

