/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(Short.MAX_VALUE, Short.MAX_VALUE);
    private MarkerPacket mkPkt;
    private Packet packet;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void connect(String var1_1, Properties var2_2) throws IOException, NetException {
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (var1_1 == null) {
            throw new NetException(208);
        }
        var7_3 = new NVFactory();
        var8_4 = new NVNavigator();
        var9_5 = null;
        var10_6 = null;
        this.addrRes = new AddrResolution(var1_1, var2_2);
        var11_7 = (String)var2_2.get("DISABLE_OOB");
        v0 = var12_8 = var11_7 != null && "true".equals(var11_7) != false;
        if (this.addrRes.connection_revised) {
            var1_1 = this.addrRes.getTNSAddress();
            var2_2 = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(var2_2);
        this.establishConnection(var1_1);
        var13_9 = null;
        try {
            var13_9 = Class.forName("oracle.net.ano.Ano").newInstance();
            this.sAtts.anoEnabled = true;
        }
        catch (Exception v1) {
            this.sAtts.anoEnabled = false;
        }
        if (var13_9 != null) {
            ((Ano)var13_9).init(this.sAtts);
            this.sAtts.ano = var13_9;
            this.sAtts.anoEnabled = true;
        }
        block15: while (true) {
            var14_13 = null;
            var3_10 = new ConnectPacket(this.sAtts, var12_8 ^ true);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                var3_10.send();
                this.packet.receive();
            }
            catch (InterruptedIOException var15_15) {
                throw var15_15;
            }
            catch (IOException var15_16) {
                this.packet.type = 4;
                var14_13 = var15_16;
            }
            switch (this.packet.type) {
                case 11: {
                    continue block15;
                }
                case 2: {
                    var4_17 = new AcceptPacket(this.packet);
                    break block15;
                }
                case 5: {
                    var6_12 = new RedirectPacket(this.packet);
                    var15_14 = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts = this.establishConnection(var6_12.getData());
                    this.sAtts.cOption.restoreFromOrigCoption((ConnOption)var15_14);
                    continue block15;
                }
                case 4: {
                    var5_11 = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    this.establishConnection(null);
                    if (this.sAtts.cOption == null) ** break;
                    continue block15;
                    if (var14_13 != null) {
                        throw var14_13;
                    }
                    try {
                        var9_5 = var8_4.findNVPairRecurse(var7_3.createNVPair(var5_11.getData()), "ERROR");
                        if (var9_5 != null && (var16_18 = var8_4.findNVPairRecurse(var9_5, "CODE")) != null) {
                            var10_6 = var16_18.valueToString();
                        }
                    }
                    catch (NLException var16_19) {
                        System.err.println(var16_19.getMessage());
                    }
                    throw new NetException(var10_6 == null ? 206 : Integer.parseInt(var10_6), "");
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
            break;
        }
        this.setNetStreams();
        this.sAtts.connected = true;
        if (var2_2.get("oracle.net.CONNECT_TIMEOUT") != null) {
            var14_13 = (String)var2_2.get("oracle.net.READ_TIMEOUT");
            this.sAtts.cOption.nt.setOption(1, var14_13 == null ? "0" : var14_13);
        }
        if ((var14_13 = (String)this.sAtts.nt.getOption(6)) != null && var14_13.equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
        if (this.sAtts.ano != null) {
            this.sAtts.ano.negotiation();
            var15_14 = (String)this.sAtts.nt.getOption(2);
            if (var15_14 != null && var15_14.equals("TRUE")) {
                try {
                    var16_20 = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (var16_20.invoke((Object)this.sAtts.ano, null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception v2) {}
            }
        }
        this.packet = null;
        var3_10 = null;
        var4_17 = null;
        var6_12 = null;
        var5_11 = null;
    }

    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    private SessionAtts establishConnection(String string) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        return this.sAtts;
    }

    public InputStream getInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    public Object getOption(int n) throws NetException, IOException {
        if (n > 0 && n < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n);
        }
        return null;
    }

    public OutputStream getOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(1);
            }
        } else {
            this.sendMarker(1);
        }
    }

    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(3);
            }
        } else {
            this.sendMarker(3);
        }
    }

    private void sendMarker(int n) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, n);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            this.packet.receive();
            if (this.packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(this.packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    public void setO3logSessionKey(byte[] byArray) throws NetException, NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    public void setOption(int n, Object object) throws NetException, IOException {
        if (n > 0 && n < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n, object);
        }
    }
}

