/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    public Vector cOpts = new Vector(10, 10);

    public ConnStrategy(Properties properties) {
        this.createSocketOptions(properties);
    }

    public void addOption(ConnOption connOption) {
        this.cOpts.addElement(connOption);
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            ((Hashtable)this.socketOptions).put(new Integer(1), "YES");
        } else if (!this.reuseOpt) {
            ((Hashtable)this.socketOptions).put(new Integer(1), "NO");
        }
    }

    public void clearElements() {
        this.cOpts.removeAllElements();
    }

    public void createSocketOptions(Properties properties) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("TCP.NODELAY")) {
                bl = true;
                string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
                if (string2.equals("NO")) {
                    ((Hashtable)this.socketOptions).put(new Integer(0), "NO");
                    continue;
                }
                ((Hashtable)this.socketOptions).put(new Integer(0), "YES");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.READ_TIMEOUT");
                ((Hashtable)this.socketOptions).put(new Integer(3), string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.CONNECT_TIMEOUT");
                ((Hashtable)this.socketOptions).put(new Integer(2), string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                string2 = properties.getProperty("oracle.net.ssl_server_dn_match");
                ((Hashtable)this.socketOptions).put(new Integer(4), string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_location")) {
                string2 = properties.getProperty("oracle.net.wallet_location");
                ((Hashtable)this.socketOptions).put(new Integer(5), string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_version")) {
                string2 = properties.getProperty("oracle.net.ssl_version");
                ((Hashtable)this.socketOptions).put(new Integer(6), string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                string2 = properties.getProperty("oracle.net.ssl_cipher_suites");
                ((Hashtable)this.socketOptions).put(new Integer(7), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                string2 = properties.getProperty("javax.net.ssl.keyStore");
                ((Hashtable)this.socketOptions).put(new Integer(8), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.keyStoreType");
                ((Hashtable)this.socketOptions).put(new Integer(9), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.keyStorePassword");
                ((Hashtable)this.socketOptions).put(new Integer(10), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                string2 = properties.getProperty("javax.net.ssl.trustStore");
                ((Hashtable)this.socketOptions).put(new Integer(11), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.trustStoreType");
                ((Hashtable)this.socketOptions).put(new Integer(12), string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.trustStorePassword");
                ((Hashtable)this.socketOptions).put(new Integer(13), string2);
                continue;
            }
            if (!string.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) continue;
            string2 = properties.getProperty("ssl.keyManagerFactory.algorithm");
            ((Hashtable)this.socketOptions).put(new Integer(14), string2);
        }
        if (!bl && !this.reuseOpt) {
            ((Hashtable)this.socketOptions).put(new Integer(0), "YES");
        }
    }

    public ConnOption execute() throws NetException {
        while (this.nextOptToTry < this.cOpts.size()) {
            try {
                this.copt = (ConnOption)this.cOpts.elementAt(this.nextOptToTry);
                this.copt.connect(this.socketOptions);
                this.copt.sdu = this.sdu;
                this.copt.tdu = this.tdu;
                this.optFound = true;
                ++this.nextOptToTry;
                return this.copt;
            }
            catch (IOException iOException) {
                ++this.nextOptToTry;
            }
        }
        throw new NetException(20);
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean hasMoreOptions() {
        return this.nextOptToTry < this.cOpts.size();
    }

    public boolean optAvailable() {
        return this.optFound;
    }
}

