/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;

    static {
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 3;
        m_byteLen = nArray;
    }

    CharacterSetUTF(int n) {
        super(n);
        this.rep = 2;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToUTF(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 2) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSet.stringToUTF(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToUTF(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        if ((n = CharacterSetUTF.getUTFByteLength(by = byArray[n2])) == 0 || n2 + (n - 1) >= n3) {
            CharacterSet.failUTFConversion();
        }
        if (n == 3 && CharacterSetUTF.isHiSurrogate(by, byArray[n2 + 1]) && n2 + 5 < n3) {
            n = 6;
        }
        try {
            char[] cArray = new char[2];
            int[] nArray = new int[]{n};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, false);
            characterWalker.next += n;
            if (n4 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (SQLException sQLException) {
            CharacterSet.failUTFConversion();
            return 0;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2;
        if ((n & 0xFFFF0000) != 0) {
            CharacterSet.need(characterBuffer, 6);
            char[] cArray = new char[]{(char)(n >>> 16), (char)n};
            n2 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 2);
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n};
            n2 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 1);
        }
        characterBuffer.next += n2;
    }

    public int encodedByteLength(String string) {
        return CharacterSet.stringUTFLength(string);
    }

    public int encodedByteLength(char[] cArray) {
        return CharacterSet.charArrayUTF8Length(cArray);
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    private static boolean isHiSurrogate(byte by, byte by2) {
        return by == -19 && by2 >= -96;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n2};
            int n3 = CharacterSet.convertUTFBytesToJavaChars(byArray, n, cArray, 0, nArray, false);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            CharacterSet.failUTFConversion();
            return "";
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n2};
            int n3 = CharacterSet.convertUTFBytesToJavaChars(byArray, n, cArray, 0, nArray, true);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }
}

