/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ArrayDescriptor;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public abstract class TypeDescriptor
implements Serializable {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    SQLName sqlName;
    OracleNamedType pickler;
    transient OracleConnection connection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:15_PDT_2010";

    protected TypeDescriptor() {
    }

    protected TypeDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.sqlName = new SQLName(string, this.getInternalConnection());
    }

    protected TypeDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (oracleTypeADT == null || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.sqlName = null;
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
    }

    protected TypeDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        if (sQLName == null || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        this.sqlName = sQLName;
        this.setPhysicalConnectionOf(connection);
    }

    protected TypeDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (sQLName == null || oracleTypeADT == null || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        this.sqlName = sQLName;
        this.setPhysicalConnectionOf(connection);
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
    }

    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        if (this.connection == null) {
            this.connection = oracleConnection;
        }
        if (this.pickler != null) {
            this.pickler.fixupConnection(oracleConnection);
        }
    }

    public OracleConnection getInternalConnection() {
        return this.connection;
    }

    public synchronized String getName() throws SQLException {
        if (this.sqlName == null) {
            this.initSQLName();
        }
        String string = this.sqlName.getName();
        return string;
    }

    public OracleNamedType getPickler() {
        return this.pickler;
    }

    public synchronized SQLName getSQLName() throws SQLException {
        if (this.sqlName == null) {
            this.initSQLName();
        }
        return this.sqlName;
    }

    public String getSchemaName() throws SQLException {
        String string = this.getSQLName().getSchema();
        return string;
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l) throws SQLException {
        if (byArray == null || byArray.length == 0 || oracleConnection == null) {
            DatabaseError.throwSqlException(68);
        }
        String string = OracleTypeADT.getSubtypeName(oracleConnection, byArray, l);
        return string;
    }

    public abstract int getTypeCode() throws SQLException;

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        try {
            SQLName sQLName = new SQLName(string, oracleConnection);
            String string2 = sQLName.getName();
            typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
            if (typeDescriptor == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
                OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
                oracleTypeADT.init(oracleConnection2);
                OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
                switch (oracleNamedType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, oracleConnection);
                        break;
                    }
                    case 2003: {
                        typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2007: {
                        typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(1);
                    }
                }
                oracleConnection.putDescriptor(string2, typeDescriptor);
                oracleNamedType.setDescriptor(typeDescriptor);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                DatabaseError.throwSqlException((SQLException)exception, 60, "Unable to resolve type \"" + string + "\"");
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type \"" + string + "\"");
        }
        return typeDescriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        byte[][] byArray2 = new byte[1][];
        String string2 = TypeDescriptor.getSubtypeName(oracleConnection, byArray, l);
        if (string2 == null) {
            string2 = string;
        }
        if ((typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2)) == null) {
            SQLName sQLName = new SQLName(string2, oracleConnection);
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
            OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
            oracleTypeADT.init(oracleConnection2);
            OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
            switch (oracleNamedType.getTypeCode()) {
                case 2002: 
                case 2008: {
                    typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, oracleConnection);
                    break;
                }
                case 2003: {
                    typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                case 2007: {
                    typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(1);
                }
            }
            oracleConnection.putDescriptor(string2, typeDescriptor);
        }
        return typeDescriptor;
    }

    public String getTypeName() throws SQLException {
        String string = this.getSQLName().getSimpleName();
        return string;
    }

    public void initMetadataRecursively() throws SQLException {
        if (this.pickler != null) {
            this.pickler.initMetadataRecursively();
        }
    }

    public void initNamesRecursively() throws SQLException {
        if (this.pickler != null) {
            this.pickler.initNamesRecursively();
        }
    }

    void initSQLName() throws SQLException {
        if (this.pickler == null || this.getInternalConnection() == null) {
            DatabaseError.throwSqlException(1);
        }
        this.sqlName = new SQLName(this.pickler.getFullName(), this.getInternalConnection());
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return false;
    }

    public void printXML(PrintStream printStream) throws SQLException {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
    }

    void printXML(PrintWriter printWriter, int n) throws SQLException {
        String string = this.getClass().getName();
        int n2 = this.hashCode();
        printWriter.println("<" + string + " hashCode=\"" + n2 + "\" >");
        if (this.pickler != null) {
            this.pickler.printXML(printWriter, n + 1);
        }
        printWriter.println("</" + string + ">");
    }

    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.sqlName = (SQLName)objectInputStream.readObject();
        this.pickler = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.pickler.setConnection(this.getInternalConnection());
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.connection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
    }

    public String toXMLString() throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
        return stringWriter.getBuffer().substring(0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        objectOutputStream.writeObject(this.sqlName);
        objectOutputStream.writeObject(this.pickler);
    }
}

