/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    private boolean closed;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:33_PDT_2010";

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSetImpl;
        this.metadata = null;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n;
        this.rsetConcurency = n2;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.beginColumnIndex = ScrollableResultSet.needIdentifier(n, n2) ? 1 : 0;
        this.columnCount = 0;
        this.wasNull = -1;
        this.rsetCache = scrollRsetStatement.getResultSetCache();
        if (this.rsetCache == null) {
            this.rsetCache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.rsetCache.clear();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
        this.currentRow = 0;
        this.numRowsCached = 0;
        this.allRowsCached = false;
        this.closed = false;
        this.lastRefetchSz = 0;
        this.refetchRowids = null;
        this.refetchStmt = null;
        this.usrFetchDirection = 1000;
        this.getInternalMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BaseResultSet baseResultSet = this;
            synchronized (baseResultSet) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            baseResultSet = this.resultSet;
            synchronized (baseResultSet) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    this.resultSet.close();
                    if (this.refetchStmt != null) {
                        this.refetchStmt.close();
                    }
                    if (this.scrollStmt != null) {
                        this.scrollStmt.notifyCloseRset();
                    }
                    if (this.refetchRowids != null) {
                        this.refetchRowids.removeAllElements();
                    }
                    this.resultSet = null;
                    this.scrollStmt = null;
                    this.refetchStmt = null;
                    this.refetchRowids = null;
                    this.metadata = null;
                    try {
                        if (this.rsetCache != null) {
                            this.rsetCache.clear();
                            this.rsetCache.close();
                        }
                    }
                    catch (IOException iOException) {
                        DatabaseError.throwSqlException(iOException);
                    }
                    this.rsetCache = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                if (this.wasNull == -1) {
                    DatabaseError.throwSqlException(24);
                }
                return this.wasNull == 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return (Statement)((Object)this.scrollStmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBeginColumnIndex() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                this.beginColumnIndex = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getResultSet() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return this.resultSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeRowInCache(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (!this.isEmptyResultSet() && this.isValidRow(n)) {
                        this.removeCachedRowAt(n);
                        --this.numRowsCached;
                        if (n >= this.currentRow) {
                            --this.currentRow;
                        }
                        return 1;
                    }
                    return 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshRowsInCache(int n, int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                OracleResultSet oracleResultSet = null;
                int n4 = 0;
                n4 = this.get_refetch_size(n, n2, n3);
                try {
                    if (n4 > 0) {
                        if (n4 != this.lastRefetchSz) {
                            if (this.refetchStmt != null) {
                                this.refetchStmt.close();
                            }
                            this.refetchStmt = this.prepare_refetch_statement(n4);
                            this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                            this.lastRefetchSz = n4;
                        }
                        this.prepare_refetch_binds(this.refetchStmt, n4);
                        oracleResultSet = (OracleResultSet)this.refetchStmt.executeQuery();
                        this.save_refetch_results(oracleResultSet, n, n4, n3);
                    }
                }
                finally {
                    if (oracleResultSet != null) {
                        oracleResultSet.close();
                    }
                }
                return n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
                    return this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return !this.isEmptyResultSet() && this.currentRow < 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return this.currentRow == 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (!this.isEmptyResultSet()) {
                        this.currentRow = 0;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (!this.isEmptyResultSet()) {
                        this.currentRow = this.getLastRow() + 1;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    this.currentRow = 1;
                    return this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    this.currentRow = this.getLastRow();
                    return this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isValidRow(this.currentRow)) {
                        return this.currentRow;
                    }
                    return 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (n == 0) {
                        DatabaseError.throwSqlException(68, "absolute (0)");
                    }
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    if (n > 0) {
                        this.currentRow = n;
                    } else if (n < 0) {
                        this.currentRow = this.getLastRow() + 1 + n;
                    }
                    return this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    if (this.isValidRow(this.currentRow)) {
                        this.currentRow += n;
                        return this.isValidRow(this.currentRow);
                    }
                    DatabaseError.throwSqlException(82, "relative");
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    if (this.isEmptyResultSet()) {
                        return false;
                    }
                    this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
                    return this.isValidRow(this.currentRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum;
                    this.wasNull = -1;
                    if (!this.isValidRow(this.currentRow)) {
                        DatabaseError.throwSqlException(11);
                    }
                    if (n < 1 || n > this.getColumnCount()) {
                        DatabaseError.throwSqlException(3);
                    }
                    this.wasNull = (datum = this.getCachedDatumValueAt(this.currentRow, n + this.beginColumnIndex)) == null ? 1 : 0;
                    return datum;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        switch (this.getInternalMetadata().getColumnType(n + this.beginColumnIndex)) {
                            case 2005: {
                                CLOB cLOB = (CLOB)datum;
                                return cLOB.getSubString(1L, (int)cLOB.length());
                            }
                        }
                        return datum.stringValue();
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.booleanValue();
                    }
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.byteValue();
                    }
                    return 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    long l = this.getLong(n);
                    if (l > 65537L || l < -65538L) {
                        DatabaseError.throwSqlException(26, "getShort");
                    }
                    return (short)l;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.intValue();
                    }
                    return 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.longValue();
                    }
                    return 0L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.floatValue();
                    }
                    return 0.0f;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.doubleValue();
                    }
                    return 0.0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.bigDecimalValue();
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    byte[] byArray = null;
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof RAW) {
                            byArray = ((RAW)datum).shareBytes();
                        } else if (datum instanceof BLOB) {
                            BLOB bLOB = (BLOB)datum;
                            long l = bLOB.length();
                            if (l > Integer.MAX_VALUE) {
                                DatabaseError.throwSqlException(151);
                            }
                            byArray = bLOB.getBytes(1L, (int)l);
                            if (bLOB.isTemporary()) {
                                this.resultSet.statement.addToTempLobsToFree(bLOB);
                            }
                        } else {
                            DatabaseError.throwSqlException(4, "getBytes");
                        }
                    }
                    return byArray;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Date date = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                date = ((TIMESTAMP)datum).dateValue();
                                break;
                            }
                            case -101: {
                                date = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                                break;
                            }
                            case -102: {
                                date = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                                break;
                            }
                            default: {
                                date = datum.dateValue();
                            }
                        }
                    }
                    return date;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Time time = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                time = ((TIMESTAMP)datum).timeValue();
                                break;
                            }
                            case -101: {
                                time = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                                break;
                            }
                            case -102: {
                                time = ((TIMESTAMPLTZ)datum).timeValue(this.connection);
                                break;
                            }
                            default: {
                                time = datum.timeValue();
                            }
                        }
                    }
                    return time;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Timestamp timestamp = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                timestamp = ((TIMESTAMP)datum).timestampValue();
                                break;
                            }
                            case -101: {
                                timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                                break;
                            }
                            case -102: {
                                timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, ((OracleStatement)this.scrollStmt).getDefaultCalendar());
                                break;
                            }
                            default: {
                                timestamp = datum.timestampValue();
                            }
                        }
                    }
                    return timestamp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.asciiStreamValue();
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        DBConversion dBConversion = this.connection.conversion;
                        byte[] byArray = datum.shareBytes();
                        if (datum instanceof RAW) {
                            return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                        }
                        if (datum instanceof CHAR) {
                            return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                        }
                        DatabaseError.throwSqlException(4, "getUnicodeStream");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.binaryStreamValue();
                    }
                    return null;
                }
            }
        }
    }

    public Object getObject(int n) throws SQLException {
        return this.getObject(n, this.connection.getTypeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        return datum.characterStreamValue();
                    }
                    return null;
                }
            }
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Object object = null;
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        int n2 = this.getInternalMetadata().getColumnType(n + this.beginColumnIndex);
                        switch (n2) {
                            case 2002: {
                                object = ((STRUCT)datum).toJdbc(map);
                                break;
                            }
                            case 91: {
                                if (!this.connection.v8Compatible) {
                                    object = datum.dateValue();
                                    break;
                                }
                                object = datum.toJdbc();
                                break;
                            }
                            default: {
                                object = datum.toJdbc();
                            }
                        }
                    }
                    return object;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.getREF(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.getBLOB(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.getCLOB(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.getARRAY(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Date date = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                date = new Date(((TIMESTAMP)datum).timestampValue().getTime());
                                break;
                            }
                            case -101: {
                                date = new Date(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                                break;
                            }
                            case -102: {
                                date = new Date(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar).getTime());
                                break;
                            }
                            case 91: {
                                date = ((DATE)datum).dateValue(calendar);
                                break;
                            }
                            default: {
                                DatabaseError.throwSqlException(4, "getDate");
                            }
                        }
                    }
                    return date;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Time time = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                time = new Time(((TIMESTAMP)datum).timestampValue().getTime());
                                break;
                            }
                            case -101: {
                                time = new Time(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                                break;
                            }
                            case -102: {
                                time = new Time(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar).getTime());
                                break;
                            }
                            case 91: {
                                time = ((DATE)datum).timeValue(calendar);
                                break;
                            }
                            default: {
                                DatabaseError.throwSqlException(4, "getTime");
                            }
                        }
                    }
                    return time;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    Timestamp timestamp = null;
                    if (datum != null) {
                        ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                        switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                            case 93: {
                                timestamp = ((TIMESTAMP)datum).timestampValue();
                                break;
                            }
                            case -101: {
                                timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                                break;
                            }
                            case -102: {
                                timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar);
                                break;
                            }
                            case 91: {
                                timestamp = ((DATE)datum).timestampValue(calendar);
                                break;
                            }
                            default: {
                                DatabaseError.throwSqlException(4, "getTimestamp");
                            }
                        }
                    }
                    return timestamp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    URL uRL = null;
                    int n2 = this.getInternalMetadata().getColumnType(n + this.beginColumnIndex);
                    int n3 = SQLUtil.getInternalType(n2);
                    if (n3 == 96 || n3 == 1 || n3 == 8) {
                        try {
                            uRL = new URL(this.getString(n));
                        }
                        catch (MalformedURLException malformedURLException) {
                            DatabaseError.throwSqlException(136);
                        }
                    } else {
                        throw new SQLException("Conversion to java.net.URL not supported.");
                    }
                    return uRL;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                DatabaseError.throwSqlException(4, "getCursor");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof ROWID) {
                            return (ROWID)datum;
                        }
                        DatabaseError.throwSqlException(4, "getROWID");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof NUMBER) {
                            return (NUMBER)datum;
                        }
                        DatabaseError.throwSqlException(4, "getNUMBER");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof DATE) {
                            return (DATE)datum;
                        }
                        DatabaseError.throwSqlException(4, "getDATE");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof TIMESTAMP) {
                            return (TIMESTAMP)datum;
                        }
                        DatabaseError.throwSqlException(4, "getTIMESTAMP");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof TIMESTAMPTZ) {
                            return (TIMESTAMPTZ)datum;
                        }
                        DatabaseError.throwSqlException(4, "getTIMESTAMPTZ");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof TIMESTAMPLTZ) {
                            return (TIMESTAMPLTZ)datum;
                        }
                        DatabaseError.throwSqlException(4, "getTIMESTAMPLTZ");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof INTERVALDS) {
                            return (INTERVALDS)datum;
                        }
                        DatabaseError.throwSqlException(4, "getINTERVALDS");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof INTERVALYM) {
                            return (INTERVALYM)datum;
                        }
                        DatabaseError.throwSqlException(4, "getINTERVALYM");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof ARRAY) {
                            return (ARRAY)datum;
                        }
                        DatabaseError.throwSqlException(4, "getARRAY");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof STRUCT) {
                            return (STRUCT)datum;
                        }
                        DatabaseError.throwSqlException(4, "getSTRUCT");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof OPAQUE) {
                            return (OPAQUE)datum;
                        }
                        DatabaseError.throwSqlException(4, "getOPAQUE");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof REF) {
                            return (REF)datum;
                        }
                        DatabaseError.throwSqlException(4, "getREF");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof CHAR) {
                            return (CHAR)datum;
                        }
                        DatabaseError.throwSqlException(4, "getCHAR");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof RAW) {
                            return (RAW)datum;
                        }
                        DatabaseError.throwSqlException(4, "getRAW");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof BLOB) {
                            return (BLOB)datum;
                        }
                        DatabaseError.throwSqlException(4, "getBLOB");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof CLOB) {
                            return (CLOB)datum;
                        }
                        DatabaseError.throwSqlException(4, "getCLOB");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    if (datum != null) {
                        if (datum instanceof BFILE) {
                            return (BFILE)datum;
                        }
                        DatabaseError.throwSqlException(4, "getBFILE");
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.getBFILE(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    return customDatumFactory.create(datum, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    Datum datum = this.getOracleObject(n);
                    return oRADataFactory.create(datum, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.resultSet.findColumn(string) - this.beginColumnIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                if (n == 1000) {
                    this.usrFetchDirection = n;
                } else if (n == 1001 || n == 1002) {
                    this.usrFetchDirection = n;
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                } else {
                    DatabaseError.throwSqlException(68, "setFetchDirection");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return 1000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    this.resultSet.setFetchSize(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = this.resultSet;
            synchronized (oracleResultSetImpl) {
                ScrollableResultSet scrollableResultSet = this;
                synchronized (scrollableResultSet) {
                    return this.resultSet.getFetchSize();
                }
            }
        }
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsetConcurency;
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
            DatabaseError.throwSqlException(23, "refreshRow");
        }
        if (this.isValidRow(this.currentRow)) {
            int n = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DatabaseError.throwSqlException(82, "refreshRow");
        }
    }

    public void setCurrentRowValueAt(Object object, int n, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.currentRow, n, object2);
        } else {
            DatabaseError.throwSqlException(1);
        }
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.numRowsCached != 0) {
            return false;
        }
        if (this.numRowsCached == 0 && this.allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int n) throws SQLException {
        if (n > 0 && n <= this.numRowsCached) {
            return true;
        }
        if (n <= 0) {
            return false;
        }
        return this.cacheRowAt(n);
    }

    private boolean cacheRowAt(int n) throws SQLException {
        while (this.numRowsCached < n && this.resultSet.next()) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                byte[] byArray = this.resultSet.privateGetBytes(i + 1);
                this.putCachedValueAt(this.numRowsCached + 1, i + 1, byArray);
            }
            ++this.numRowsCached;
        }
        if (this.numRowsCached < n) {
            this.allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.resultSet.next()) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.putCachedValueAt(this.numRowsCached + 1, i + 1, this.resultSet.privateGetBytes(i + 1));
            }
            ++this.numRowsCached;
        }
        this.allRowsCached = true;
        return this.numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            int n = this.resultSet.statement.numberOfDefinePositions;
            this.columnCount = this.resultSet.statement.accessors != null && n > 0 ? n : this.getInternalMetadata().getColumnCount();
        }
        return this.columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.resultSet.getMetaData();
        }
        return this.metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.allRowsCached) {
            this.cacheAllRows();
        }
        return this.numRowsCached;
    }

    private int get_refetch_size(int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        int n5 = 0;
        if (this.refetchRowids == null) {
            this.refetchRowids = new Vector(10);
        } else {
            this.refetchRowids.removeAllElements();
        }
        while (n5 < n2 && this.isValidRow(n + n5 * n4)) {
            this.refetchRowids.addElement(this.getCachedDatumValueAt(n + n5 * n4, 1));
            ++n5;
        }
        return n5;
    }

    private OraclePreparedStatement prepare_refetch_statement(int n) throws SQLException {
        if (n < 1) {
            DatabaseError.throwSqlException(68);
        }
        return (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, n));
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2 = this.scrollStmt.copyBinds(oraclePreparedStatement, 0);
        for (int i = 0; i < n; ++i) {
            oraclePreparedStatement.setROWID(n2 + i + 1, (ROWID)this.refetchRowids.elementAt(i));
        }
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n, int n2, int n3) throws SQLException {
        int n4;
        int n5 = n4 = n3 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl = false;
            int n6 = n;
            while (!bl && n6 < n + n2 * n4) {
                if (((ROWID)this.getCachedDatumValueAt(n6, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n6 += n4;
            }
            if (!bl) continue;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.putCachedValueAt(n6, i + 1, oracleResultSet.getOracleObject(i + 1));
            }
        }
    }

    private Object getCachedValueAt(int n, int n2) throws SQLException {
        try {
            return this.rsetCache.get(n, n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return null;
        }
    }

    private Datum getCachedDatumValueAt(int n, int n2) throws SQLException {
        Object object = null;
        try {
            object = this.rsetCache.get(n, n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n3 = this.getInternalMetadata().getColumnType(n2);
                int n4 = this.getInternalMetadata().getColumnDisplaySize(n2);
                int n5 = this.scrollStmt.getMaxFieldSize();
                if (n5 > 0 && n5 < n4) {
                    n4 = n5;
                }
                String string = null;
                if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n2);
                }
                int n6 = SQLUtil.getInternalType(n3);
                short s = this.resultSet.statement.accessors[n2 - 1].formOfUse;
                datum = s == 2 && (n6 == 96 || n6 == 1 || n6 == 8 || n6 == 112) ? SQLUtil.makeNDatum(this.connection, (byte[])object, n6, string, s, n4) : SQLUtil.makeDatum((OracleConnection)this.connection, (byte[])object, n6, string, n4);
                try {
                    this.rsetCache.put(n, n2, datum);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.rsetCache.put(n, n2, null);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private void putCachedValueAt(int n, int n2, Object object) throws SQLException {
        try {
            this.rsetCache.put(n, n2, object);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    private void removeCachedRowAt(int n) throws SQLException {
        try {
            this.rsetCache.remove(n);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public static boolean needIdentifier(int n, int n2) {
        return (n != 1003 || n2 != 1007) && (n != 1004 || n2 != 1007);
    }

    public static boolean needCache(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    public static boolean supportRefreshRow(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    int getFirstUserColumnIndex() {
        return this.beginColumnIndex;
    }
}

