/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class T2CInputStream
extends OracleInputStream {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:34_PDT_2010";

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, byte[] var7, int var8, char[] var9, int var10, short[] var11, int var12);

    T2CInputStream(OracleStatement oracleStatement, int n, Accessor accessor) {
        super(oracleStatement, n, accessor);
    }

    T2CInputStream(int n) {
        super(null, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes(int n) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2;
            if (n > this.currentBufferSize) {
                this.currentBufferSize = Math.max(n, this.initialBufferSize);
                this.resizableBuffer = new byte[this.currentBufferSize];
            }
            if ((n2 = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.resizableBuffer, this.currentBufferSize, this.statement.accessors, this.statement.defineBytes, this.statement.accessorByteOffset, this.statement.defineChars, this.statement.accessorCharOffset, this.statement.defineIndicators, this.statement.accessorShortOffset)) == -2) {
                try {
                    this.accessor.setNull(this.statement.currentRow);
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
                n2 = 0;
            }
            if (n2 <= 0) {
                n2 = -1;
            }
            return n2;
        }
    }
}

