/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;

    CharacterSetGB18030(int n, CharacterConverters characterConverters) {
        super(n, characterConverters);
    }

    static CharacterSetGB18030 getInstance(int n, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 9) {
            return new CharacterSetGB18030(n, characterConverters);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        if (n <= 127) return n;
        if (characterWalker.bytes.length <= characterWalker.next + 1) throw new SQLException("destination too small");
        if ((characterWalker.bytes[characterWalker.next] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) <= 57) {
            if (characterWalker.bytes.length <= characterWalker.next + 3) throw new SQLException("destination too small");
            if ((characterWalker.bytes[characterWalker.next + 2] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next + 2] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) <= 57) {
                n = (characterWalker.bytes[characterWalker.next] & 0xFF) << 24 | (characterWalker.bytes[characterWalker.next + 1] & 0xFF) << 16 | (characterWalker.bytes[characterWalker.next + 2] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 3] & 0xFF;
                characterWalker.next += 4;
                return n;
            } else {
                n = characterWalker.bytes[characterWalker.next] & 0xFF;
                ++characterWalker.next;
            }
            return n;
        } else {
            n = (characterWalker.bytes[characterWalker.next] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 1] & 0xFF;
            characterWalker.next += 2;
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        while (n >> n2 != 0) {
            n2 = (short)(n2 + 8);
            n3 = (short)(n3 + 1);
        }
        if (n >> 16 != 0) {
            n2 = 3;
            n3 = 4;
        } else if (n >> 8 != 0) {
            n2 = 1;
            n3 = 2;
        } else {
            n2 = 0;
            n3 = 1;
        }
        CharacterSetGB18030.need(characterBuffer, n3);
        while (n2 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> n2 & 0xFF);
            n2 = (short)(n2 - 8);
        }
    }
}

