/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements Struct {
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache = false;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:12_PDT_2010";
    static /* synthetic */ Class class$oracle$sql$STRUCT;
    static /* synthetic */ Class class$java$sql$Struct;

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            throw new SQLException("Cannot construct STRUCT instance for a non-instantiable object type");
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = objectArray != null ? this.descriptor.toArray(objectArray) : new Datum[this.descriptor.getLength()];
    }

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Map map) throws SQLException {
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            throw new SQLException("Cannot construct STRUCT instance for a non-instantiable object type");
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = this.descriptor.toOracleArray(map);
    }

    public STRUCT(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        structDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
    }

    public synchronized String getSQLTypeName() throws SQLException {
        String string = this.descriptor.getName();
        return string;
    }

    public synchronized Object[] getAttributes() throws SQLException {
        Object[] objectArray = this.getAttributes(this.getMap());
        return objectArray;
    }

    public synchronized Object[] getAttributes(Map map) throws SQLException {
        Object[] objectArray = this.descriptor.toArray(this, map, this.enableLocalCache);
        return objectArray;
    }

    public synchronized StructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public synchronized void setDescriptor(StructDescriptor structDescriptor) {
        this.descriptor = structDescriptor;
    }

    public synchronized Datum[] getOracleAttributes() throws SQLException {
        Datum[] datumArray = this.descriptor.toOracleArray(this, this.enableLocalCache);
        return datumArray;
    }

    public Map getMap() {
        Map map = null;
        try {
            map = this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return map;
    }

    public synchronized byte[] toBytes() throws SQLException {
        byte[] byArray = this.descriptor.toBytes(this, this.enableLocalCache);
        return byArray;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        try {
            this.datumArray = datumArray == null ? new Datum[this.descriptor.getLength()] : datumArray;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void setObjArray(Object[] objectArray) throws SQLException {
        this.objectArray = objectArray == null ? new Object[]{} : objectArray;
    }

    public static STRUCT toSTRUCT(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        STRUCT sTRUCT = null;
        if (object != null) {
            if (object instanceof STRUCT) {
                sTRUCT = (STRUCT)object;
            } else if (object instanceof ORAData) {
                sTRUCT = (STRUCT)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof CustomDatum) {
                sTRUCT = (STRUCT)((OracleConnection)oracleConnection).toDatum((CustomDatum)object);
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)oracleConnection);
                SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
                sQLData.writeSQL(sQLOutput);
                sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return sTRUCT;
    }

    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        Object object = this.toJdbc(map);
        return object;
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        Object object = this.toClass(clazz, this.getMap());
        return object;
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object = null;
        try {
            if (clazz == null || clazz == (class$oracle$sql$STRUCT == null ? (class$oracle$sql$STRUCT = STRUCT.class$("oracle.sql.STRUCT")) : class$oracle$sql$STRUCT) || clazz == (class$java$sql$Struct == null ? (class$java$sql$Struct = STRUCT.class$("java.sql.Struct")) : class$java$sql$Struct)) {
                object = this;
            } else {
                Object t = clazz.newInstance();
                if (t instanceof SQLData) {
                    ((SQLData)t).readSQL(this.descriptor.toJdbc2SQLInput(this, map), this.descriptor.getName());
                    object = t;
                } else if (t instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t;
                    object = oRADataFactory.create(this, 2002);
                } else if (t instanceof CustomDatumFactory) {
                    CustomDatumFactory customDatumFactory = (CustomDatumFactory)t;
                    object = customDatumFactory.create(this, 2002);
                } else {
                    DatabaseError.throwSqlException(49, this.descriptor.getName());
                }
            }
        }
        catch (InstantiationException instantiationException) {
            DatabaseError.throwSqlException(49, "InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            DatabaseError.throwSqlException(49, "IllegalAccessException: " + illegalAccessException.getMessage());
        }
        return object;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new Object[n];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.enableLocalCache = bl;
    }

    public synchronized boolean getAutoBuffering() throws SQLException {
        return this.enableLocalCache;
    }

    public void setImage(byte[] byArray, long l, long l2) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l;
        this.imageLength = l2;
    }

    public void setImageLength(long l) throws SQLException {
        this.imageLength = l;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public long getImageLength() {
        return this.imageLength;
    }

    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        CustomDatumFactory customDatumFactory = (CustomDatumFactory)v;
        return customDatumFactory;
    }

    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        ORADataFactory oRADataFactory = (ORADataFactory)v;
        return oRADataFactory;
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n = structDescriptor.getLength();
            stringWriter.write(" length = " + n);
            Object[] objectArray = this.getAttributes();
            for (int i = 0; i < n; ++i) {
                stringWriter.write(" attribute[" + i + "] = " + objectArray[i]);
            }
        }
        catch (SQLException sQLException) {
            string = "StructDescriptor missing or bad";
        }
        string = stringWriter.getBuffer().substring(0);
        return string;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        boolean bl = this.getDescriptor().isInHierarchyOf(string);
        return bl;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public String dump() throws SQLException {
        return STRUCT.dump(this);
    }

    public static String dump(Object object) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        STRUCT.dump(object, printWriter);
        return stringWriter.getBuffer().substring(0);
    }

    public static void dump(Object object, PrintStream printStream) throws SQLException {
        STRUCT.dump(object, new PrintWriter(printStream, true));
    }

    public static void dump(Object object, PrintWriter printWriter) throws SQLException {
        STRUCT.dump(object, printWriter, 0);
    }

    static void dump(Object object, PrintWriter printWriter, int n) throws SQLException {
        if (object instanceof STRUCT) {
            STRUCT.dump((STRUCT)object, printWriter, n);
            return;
        }
        if (object instanceof ARRAY) {
            ARRAY.dump((ARRAY)object, printWriter, n);
            return;
        }
        printWriter.println(object.toString());
    }

    static void dump(STRUCT sTRUCT, PrintWriter printWriter, int n) throws SQLException {
        int n2;
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print(' ');
        }
        printWriter.println("name = " + structDescriptor.getName());
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print(' ');
        }
        int n3 = structDescriptor.getLength();
        printWriter.println("length = " + n3);
        Object[] objectArray = sTRUCT.getAttributes();
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n; ++i) {
                printWriter.print(' ');
            }
            printWriter.print(resultSetMetaData.getColumnName(n2 + 1) + " = ");
            STRUCT.dump(objectArray[n2], printWriter, n + 1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

