/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Long.MAX_VALUE;
    boolean isClosed;
    boolean endOfStream;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:31_PDT_2010";

    public OracleClobReader(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getInternalConnection()).getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobReader(CLOB cLOB, int n, long l) throws SQLException {
        if (cLOB == null || n <= 0 || cLOB.getInternalConnection() == null || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.dbConversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lobOffset = l;
        this.markedChar = -1L;
        this.resizableBuffer = null;
        this.initialBufferSize = n;
        this.currentBufferSize = 0;
        this.count = 0;
        this.pos = 0;
        this.isClosed = false;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n;
        int n4 = n3 + Math.min(n2, cArray.length - n);
        if (!this.needChars(n4 - n3)) {
            return -1;
        }
        n3 += this.writeChars(cArray, n3, n4 - n3);
        while (n3 < n4 && this.needChars(n4 - n3)) {
            n3 += this.writeChars(cArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    protected boolean needChars(int n) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    if (n > this.currentBufferSize) {
                        this.currentBufferSize = Math.max(n, this.initialBufferSize);
                        this.resizableBuffer = new char[this.currentBufferSize];
                    }
                    int n2 = this.currentBufferSize;
                    if (this.maxPosition - this.lobOffset < (long)this.currentBufferSize) {
                        n2 = (int)(this.maxPosition - this.lobOffset);
                    }
                    this.count = this.clob.getChars(this.lobOffset, n2, this.resizableBuffer);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.count - this.pos);
        System.arraycopy(this.resizableBuffer, this.pos, cArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.resizableBuffer = null;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        long l2 = 0L;
        if ((long)(this.count - this.pos) >= l) {
            this.pos = (int)((long)this.pos + l);
            l2 += l;
        } else {
            l2 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l3 = this.clob.length() - this.lobOffset + 1L;
                if (l3 >= l - l2) {
                    this.lobOffset += l - l2;
                    l2 += l - l2;
                } else {
                    this.lobOffset += l3;
                    l2 += l3;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
        return l2;
    }
}

