/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:09_PDT_2010";

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(string, connection, false, false);
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        return ArrayDescriptor.createDescriptor(sQLName, connection);
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        ArrayDescriptor arrayDescriptor = null;
        if (!bl2) {
            arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
        }
        if (arrayDescriptor == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
            if (bl) {
                arrayDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        String string = oracleTypeCOLLECTION.getFullName();
        OracleConnection oracleConnection = oracleTypeCOLLECTION.getConnection();
        ArrayDescriptor arrayDescriptor = (ArrayDescriptor)oracleConnection.getDescriptor(string);
        if (arrayDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeCOLLECTION.getSchemaName(), oracleTypeCOLLECTION.getSimpleName(), oracleTypeCOLLECTION.getConnection());
            arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, (Object)arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(sQLName, oracleTypeCOLLECTION, connection);
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(oracleTypeCOLLECTION, connection);
    }

    static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n, byte[] byArray2, byte[] byArray3, OracleConnection oracleConnection, byte[] byArray4) throws SQLException {
        OracleTypeCOLLECTION oracleTypeCOLLECTION = new OracleTypeCOLLECTION(sQLName, byArray, n, byArray2, byArray3, oracleConnection, byArray4);
        return new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
    }

    public int getBaseType() throws SQLException {
        int n = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
        return n;
    }

    public String getBaseName() throws SQLException {
        String string = null;
        switch (this.getBaseType()) {
            case 12: {
                string = "VARCHAR";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case -2: {
                string = "RAW";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 2: {
                string = "NUMBER";
                break;
            }
            case 8: {
                string = "DOUBLE";
                break;
            }
            case 3: {
                string = "DECIMAL";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case -101: {
                string = "TIMESTAMPTZ";
                break;
            }
            case -102: {
                string = "TIMESTAMPLTZ";
                break;
            }
            case 2004: {
                string = "BLOB";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case -13: {
                string = "BFILE";
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                string = oracleNamedType.getFullName();
                break;
            }
            case 2006: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                string = "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.pickler;
    }

    public int getArrayType() throws SQLException {
        int n = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
        return n;
    }

    public long getMaxLength() throws SQLException {
        long l = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
        return l;
    }

    public String descType() throws SQLException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        string = this.descType(stringBuffer, 0);
        return string;
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        Object object;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n2 = this.getBaseType();
        if (n2 == 2002 || n2 == 2008) {
            object = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            ((StructDescriptor)object).descType(stringBuffer, n + 1);
        } else if (n2 == 2003) {
            object = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            ((ArrayDescriptor)object).descType(stringBuffer, n + 1);
        } else if (n2 == 2007) {
            object = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            ((OpaqueDescriptor)object).descType(stringBuffer, n + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        object = stringBuffer.substring(0, stringBuffer.length());
        return object;
    }

    int toLength(ARRAY aRRAY) throws SQLException {
        if (aRRAY.numElems == -1) {
            if (aRRAY.datumArray != null) {
                aRRAY.numElems = aRRAY.datumArray.length;
            } else if (aRRAY.objArray != null) {
                if (aRRAY.objArray instanceof Object[]) {
                    aRRAY.numElems = ((Object[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof int[]) {
                    aRRAY.numElems = ((long[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof long[]) {
                    aRRAY.numElems = ((float[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof float[]) {
                    aRRAY.numElems = ((double[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof double[]) {
                    aRRAY.numElems = ((boolean[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof boolean[]) {
                    aRRAY.numElems = ((int[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof byte[]) {
                    aRRAY.numElems = ((byte[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof short[]) {
                    aRRAY.numElems = ((short[])aRRAY.objArray).length;
                } else if (aRRAY.objArray instanceof char[]) {
                    aRRAY.numElems = ((char[])aRRAY.objArray).length;
                }
            } else if (aRRAY.locator != null) {
                aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 0, null);
                if (aRRAY.numElems == -1) {
                    if (aRRAY.locator != null) {
                        aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
                    } else {
                        DatabaseError.throwSqlException(1, "Unable to get array length");
                    }
                }
            } else {
                DatabaseError.throwSqlException(1, "Array is in inconsistent status");
            }
        }
        int n = aRRAY.numElems;
        return n;
    }

    byte[] toBytes(ARRAY aRRAY, boolean bl) throws SQLException {
        byte[] byArray = aRRAY.shareBytes();
        if (byArray == null) {
            if (aRRAY.datumArray != null || aRRAY.locator != null) {
                byArray = this.pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.setShareBytes(null);
                }
            } else if (aRRAY.objArray != null) {
                aRRAY.datumArray = this.toOracleArray(aRRAY.objArray, 1L, -1);
                byArray = this.pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.datumArray = null;
                    aRRAY.setShareBytes(null);
                }
            } else {
                DatabaseError.throwSqlException(1, "Array is in inconsistent status");
            }
        } else if (aRRAY.imageLength != 0L && (aRRAY.imageOffset != 0L || aRRAY.imageLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)aRRAY.imageLength];
            System.arraycopy(byArray, (int)aRRAY.imageOffset, byArray2, 0, (int)aRRAY.imageLength);
            aRRAY.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
        return byArray;
    }

    Datum[] toOracleArray(ARRAY aRRAY, long l, int n, boolean bl) throws SQLException {
        Datum[] datumArray = aRRAY.datumArray;
        if (datumArray == null) {
            if (aRRAY.objArray != null) {
                datumArray = this.toOracleArray(aRRAY.objArray, l, n);
            } else if (aRRAY.locator != null) {
                datumArray = this.toOracleArrayFromLocator(aRRAY.locator, l, n, null);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l, n, 1, null);
                datumArray = aRRAY.locator != null ? this.toOracleArrayFromLocator(aRRAY.locator, l, n, null) : aRRAY.datumArray;
                if (!bl) {
                    aRRAY.datumArray = null;
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else {
            if (l > (long)datumArray.length) {
                return new Datum[0];
            }
            int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
            datumArray = new Datum[n2];
            System.arraycopy(aRRAY.datumArray, (int)l - 1, datumArray, 0, n2);
        }
        Datum[] datumArray2 = null;
        if (bl) {
            aRRAY.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    Object[] toJavaArray(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (aRRAY.objArray != null) {
            objectArray = (Object[])((Object[])aRRAY.objArray).clone();
            int n2 = objectArray.length;
            int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
            if (n3 <= 0) {
                Object[] objectArray2 = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
                return objectArray2;
            }
            objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            System.arraycopy(aRRAY.objArray, (int)l - 1, objectArray, 0, n3);
        } else {
            if (aRRAY.datumArray != null) {
                objectArray = (Object[])this.toJavaArray(aRRAY.datumArray, l, n, map);
            } else if (aRRAY.locator != null) {
                objectArray = this.toArrayFromLocator(aRRAY.locator, l, n, map);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l, n, 2, map);
                objectArray = aRRAY.locator != null ? this.toArrayFromLocator(aRRAY.locator, l, n, map) : (Object[])aRRAY.objArray;
            } else {
                DatabaseError.throwSqlException(1);
            }
            aRRAY.objArray = bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null ? objectArray.clone() : null;
        }
        return objectArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        Datum[] datumArray = null;
        if (n3 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n3];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
            int n4 = 0;
            while (resultSet.next()) {
                datumArray[n4] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n4;
            }
            resultSet.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        Object[] objectArray = null;
        if (n3 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
            int n4 = 0;
            while (resultSet.next()) {
                objectArray[n4] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n4;
            }
            resultSet.close();
        }
        return objectArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        if (aRRAY.datumArray != null) {
            resultSet = this.toResultSet(aRRAY.datumArray, l, n, map);
        } else if (aRRAY.locator != null) {
            resultSet = this.toResultSetFromLocator(aRRAY.locator, l, n, map);
        } else if (aRRAY.objArray != null) {
            resultSet = this.toResultSet(this.toOracleArray(aRRAY.objArray, l, n), 1L, -1, map);
        } else if (aRRAY.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(aRRAY.shareBytes(), (int)aRRAY.imageOffset)) {
                resultSet = this.toResultSetFromImage(aRRAY, l, n, map);
            } else {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 1, null);
                if (aRRAY.locator != null) {
                    resultSet = this.toResultSetFromLocator(aRRAY.locator, l, n, map);
                } else {
                    DatabaseError.throwSqlException(1);
                }
            }
        }
        if (resultSet == null) {
            DatabaseError.throwSqlException(1, "Unable to create array ResultSet");
        }
        return resultSet;
    }

    public ResultSet toResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = null;
        resultSet = n == -1 ? this.connection.newArrayDataResultSet(datumArray, l, datumArray.length, map) : this.connection.newArrayDataResultSet(datumArray, l, n, map);
        return resultSet;
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayLocatorResultSet(this, byArray, l, n, map);
        return resultSet;
    }

    public ResultSet toResultSetFromImage(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayDataResultSet(aRRAY, l, n, map);
        return resultSet;
    }

    public static Object[] makeJavaArray(int n, int n2) throws SQLException {
        Object[] objectArray = null;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = new BigDecimal[n];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new String[n];
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = new Timestamp[n];
                break;
            }
            case 2002: 
            case 2008: {
                objectArray = new Object[n];
                break;
            }
            case -13: {
                objectArray = new BFILE[n];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n];
                break;
            }
            case -3: 
            case -2: {
                objectArray = (Object[])new byte[n][];
                break;
            }
            case 2006: {
                objectArray = new REF[n];
                break;
            }
            case 2003: {
                objectArray = new Object[n];
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "makeJavaArray doesn't support type " + n2);
            }
        }
        return objectArray;
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, (Object)null);
        aRRAY.setLocator(byArray);
        int n = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (oracleResultSet.next()) {
            n = oracleResultSet.getInt(1);
        } else {
            DatabaseError.throwSqlException(1, "Fail to access array storage table");
        }
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n;
    }

    Datum[] toOracleArray(Object object, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            OracleType oracleType = this.getElementType();
            datumArray = oracleType.toDatumArray(object, this.connection, l, n);
        }
        return datumArray;
    }

    private Object toJavaArray(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n2 < 0) {
            n2 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n2, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT sTRUCT = null;
            for (int i = 0; i < n2; ++i) {
                sTRUCT = (STRUCT)datumArray[(int)l + i - 1];
                objectArray[i] = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
            }
        } else {
            Datum datum = null;
            for (int i = 0; i < n2; ++i) {
                datum = datumArray[(int)l + i - 1];
                objectArray[i] = datum != null ? datum.toJdbc() : null;
            }
        }
        return objectArray;
    }

    private Object toNumericArray(Datum[] datumArray, long l, int n, int n2) throws SQLException {
        Object[] objectArray = null;
        int n3 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n3 < 0) {
            n3 = 0;
        }
        switch (n2) {
            case 4: {
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    Datum datum = datumArray[(int)l + i - 1];
                    if (datum == null) continue;
                    nArray[i] = datum.intValue();
                }
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    Datum datum = datumArray[(int)l + i - 1];
                    if (datum == null) continue;
                    dArray[i] = datum.doubleValue();
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    Datum datum = datumArray[(int)l + i - 1];
                    if (datum == null) continue;
                    fArray[i] = datum.floatValue();
                }
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n3];
                for (int i = 0; i < n3; ++i) {
                    Datum datum = datumArray[(int)l + i - 1];
                    if (datum == null) continue;
                    lArray[i] = datum.longValue();
                }
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    Datum datum = datumArray[(int)l + i - 1];
                    if (datum == null) continue;
                    sArray[i] = ((NUMBER)datum).shortValue();
                }
                objectArray = sArray;
                break;
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
        return objectArray;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l, int n, int n2) throws SQLException {
        Object[] objectArray = null;
        int n3 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, null);
        int n4 = 0;
        switch (n2) {
            case 4: {
                int[] nArray = new int[n3];
                while (resultSet.next() && n4 < n3) {
                    nArray[n4++] = ((OracleResultSet)resultSet).getInt(2);
                }
                resultSet.close();
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n3];
                while (resultSet.next() && n4 < n3) {
                    dArray[n4++] = ((OracleResultSet)resultSet).getDouble(2);
                }
                resultSet.close();
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n3];
                while (resultSet.next() && n4 < n3) {
                    fArray[n4++] = ((OracleResultSet)resultSet).getFloat(2);
                }
                resultSet.close();
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n3];
                while (resultSet.next() && n4 < n3) {
                    lArray[n4++] = ((OracleResultSet)resultSet).getLong(2);
                }
                resultSet.close();
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n3];
                while (resultSet.next() && n4 < n3) {
                    sArray[n4++] = ((OracleResultSet)resultSet).getShort(2);
                }
                resultSet.close();
                objectArray = sArray;
                break;
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
        return objectArray;
    }

    Object toNumericArray(ARRAY aRRAY, long l, int n, int n2, boolean bl) throws SQLException {
        if (!(this.getElementType() instanceof OracleTypeNUMBER) && !(this.getElementType() instanceof OracleTypeFLOAT)) {
            DatabaseError.throwSqlException(23);
        }
        Object object = null;
        if (aRRAY.objArray != null) {
            if (n2 == 4 && aRRAY.objArray instanceof int[]) {
                int n3 = ((int[])aRRAY.objArray).length;
                if (l > (long)n3) {
                    return new int[0];
                }
                n3 = (int)(n == -1 ? (long)n3 - l + 1L : Math.min((long)n3 - l + 1L, (long)n));
                int[] nArray = new int[n3];
                System.arraycopy(aRRAY.objArray, (int)l - 1, nArray, 0, n3);
                object = nArray;
            } else if (n2 == 5 && aRRAY.objArray instanceof double[]) {
                int n4 = ((double[])aRRAY.objArray).length;
                if (l > (long)n4) {
                    return new double[0];
                }
                n4 = (int)(n == -1 ? (long)n4 - l + 1L : Math.min((long)n4 - l + 1L, (long)n));
                double[] dArray = new double[n4];
                System.arraycopy(aRRAY.objArray, (int)l - 1, dArray, 0, n4);
                object = dArray;
            } else if (n2 == 6 && aRRAY.objArray instanceof float[]) {
                int n5 = ((float[])aRRAY.objArray).length;
                if (l > (long)n5) {
                    return new float[0];
                }
                n5 = (int)(n == -1 ? (long)n5 - l + 1L : Math.min((long)n5 - l + 1L, (long)n));
                float[] fArray = new float[n5];
                System.arraycopy(aRRAY.objArray, (int)l - 1, fArray, 0, n5);
                object = fArray;
            } else if (n2 == 7 && aRRAY.objArray instanceof long[]) {
                int n6 = ((long[])aRRAY.objArray).length;
                if (l > (long)n6) {
                    return new long[0];
                }
                n6 = (int)(n == -1 ? (long)n6 - l + 1L : Math.min((long)n6 - l + 1L, (long)n));
                long[] lArray = new long[n6];
                System.arraycopy(aRRAY.objArray, (int)l - 1, lArray, 0, n6);
                object = lArray;
            } else if (n2 == 8 && aRRAY.objArray instanceof short[]) {
                int n7 = ((short[])aRRAY.objArray).length;
                if (l > (long)n7) {
                    return new short[0];
                }
                n7 = (int)(n == -1 ? (long)n7 - l + 1L : Math.min((long)n7 - l + 1L, (long)n));
                short[] sArray = new short[n7];
                System.arraycopy(aRRAY.objArray, (int)l - 1, sArray, 0, n7);
                object = sArray;
            }
        } else {
            if (aRRAY.datumArray != null) {
                object = this.toNumericArray(aRRAY.datumArray, l, n, n2);
            } else if (aRRAY.locator != null) {
                object = this.toNumericArrayFromLocator(aRRAY.locator, l, n, n2);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l, n, n2, null);
                object = aRRAY.locator != null ? this.toNumericArrayFromLocator(aRRAY.locator, l, n, n2) : aRRAY.objArray;
            } else {
                DatabaseError.throwSqlException(1);
            }
            if (!bl) {
                aRRAY.objArray = null;
            }
        }
        return object;
    }

    private void initPickler() throws SQLException {
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getName(), (Connection)this.connection);
            oracleTypeADT.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type: \"" + this.getName() + "\"");
        }
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return oracleType;
    }

    public int getTypeCode() throws SQLException {
        int n = 2003;
        return n;
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, datumArray);
        return this.pickler.linearize(aRRAY);
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        byte[] byArray = this.toBytes(datumArray);
        return byArray;
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
        int n = this.toLength(aRRAY);
        return n;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        Datum[] datumArray = null;
        if (byArray != null) {
            ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
            datumArray = this.toOracleArray(aRRAY, 1L, -1, false);
        }
        return datumArray;
    }

    public Datum[] toArray(Object object) throws SQLException {
        Datum[] datumArray = this.toOracleArray(object, 1L, -1);
        return datumArray;
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, 1L, -1, map, false);
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, l, n, map, false);
        }
        return resultSet;
    }

    public static int getCacheStyle(ARRAY aRRAY) throws SQLException {
        int n = 2;
        if (aRRAY.getAutoIndexing() && (aRRAY.getAccessDirection() == 2 || aRRAY.getAccessDirection() == 3)) {
            n = 1;
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

