/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;

class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    int[] returnTypes;
    Accessor[] returnAccessors;

    AutoKeyInfo(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String string, int[] nArray) {
        this.originalSql = string;
        this.columnIndexes = nArray;
        this.autoKeyType = 2;
    }

    AutoKeyInfo(String string, String[] stringArray) {
        this.originalSql = string;
        this.columnNames = stringArray;
        this.autoKeyType = 1;
    }

    void allocateSpaceForDescribedData(int n) throws SQLException {
        this.numColumns = n;
        this.tableColumnNames = new String[n];
        this.tableColumnTypes = new int[n];
        this.tableMaxLengths = new int[n];
        this.tableNullables = new boolean[n];
        this.tableFormOfUses = new short[n];
        this.tablePrecisions = new int[n];
        this.tableScales = new int[n];
        this.tableTypeNames = new String[n];
    }

    void fillDescribedData(int n, String string, int n2, int n3, boolean bl, short s, int n4, int n5, String string2) throws SQLException {
        this.tableColumnNames[n] = string;
        this.tableColumnTypes[n] = n2;
        this.tableMaxLengths[n] = n3;
        this.tableNullables[n] = bl;
        this.tableFormOfUses[n] = s;
        this.tablePrecisions[n] = n4;
        this.tableScales[n] = n5;
        this.tableTypeNames[n] = string2;
    }

    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    public String getColumnName(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.returnAccessors[n - 1].columnName;
    }

    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }

    String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.newSql = String.valueOf(this.originalSql) + " RETURNING ROWID INTO ?";
                this.returnTypes = new int[1];
                this.returnTypes[0] = 104;
                return this.newSql;
            }
            case 1: {
                return this.getNewSqlByColumnName();
            }
            case 2: {
                return this.getNewSqlByColumnIndexes();
            }
        }
        DatabaseError.throwSqlException(89);
        return null;
    }

    private String getNewSqlByColumnIndexes() throws SQLException {
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        int n = 0;
        while (n < this.columnIndexes.length) {
            int n2 = this.columnIndexes[n] - 1;
            if (n2 < 0 || n2 > this.tableColumnNames.length) {
                DatabaseError.throwSqlException(68);
            }
            int n3 = this.tableColumnTypes[n2];
            String string = this.tableColumnNames[n2];
            this.returnTypes[n] = n3;
            stringBuffer.append(string);
            if (n < this.columnIndexes.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" INTO ");
        n = 0;
        while (n < this.columnIndexes.length - 1) {
            stringBuffer.append("?, ");
            ++n;
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private String getNewSqlByColumnName() throws SQLException {
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        int n = 0;
        while (n < this.columnNames.length) {
            int n2;
            this.returnTypes[n] = n2 = this.getReturnParamTypeCode(n, this.columnNames[n], this.columnIndexes);
            stringBuffer.append(this.columnNames[n]);
            if (n < this.columnNames.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" INTO ");
        n = 0;
        while (n < this.columnNames.length - 1) {
            stringBuffer.append("?, ");
            ++n;
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private final int getReturnParamTypeCode(int n, String string, int[] nArray) throws SQLException {
        int n2 = 0;
        while (n2 < this.tableColumnNames.length) {
            if (string.equalsIgnoreCase(this.tableColumnNames[n2])) {
                nArray[n] = n2 + 1;
                return this.tableColumnTypes[n2];
            }
            ++n2;
        }
        DatabaseError.throwSqlException(68);
        return -1;
    }

    String getTableName() throws SQLException {
        if (this.tableName != null) {
            return this.tableName;
        }
        String string = this.originalSql.trim().toUpperCase();
        int n = string.indexOf("INSERT");
        if ((n = string.indexOf("INTO", n)) < 0) {
            DatabaseError.throwSqlException(68);
        }
        int n2 = string.length();
        int n3 = n + 5;
        while (n3 < n2 && string.charAt(n3) == ' ') {
            ++n3;
        }
        if (n3 >= n2) {
            DatabaseError.throwSqlException(68);
        }
        int n4 = n3 + 1;
        while (n4 < n2 && string.charAt(n4) != ' ' && string.charAt(n4) != '(') {
            ++n4;
        }
        if (n3 == n4 - 1) {
            DatabaseError.throwSqlException(68);
        }
        this.tableName = string.substring(n3, n4);
        return this.tableName;
    }

    public String getTableName(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.getTableName();
    }

    int getValidColumnIndex(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return n - 1;
    }

    void initMetaData(OracleReturnResultSet oracleReturnResultSet) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        this.returnAccessors = oracleReturnResultSet.returnAccessors;
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
                break;
            }
        }
    }

    void initMetaDataColumnIndexes() throws SQLException {
        int n = 0;
        while (n < this.returnAccessors.length) {
            Accessor accessor = this.returnAccessors[n];
            int n2 = this.columnIndexes[n] - 1;
            accessor.columnName = this.tableColumnNames[n2];
            accessor.describeType = this.tableColumnTypes[n2];
            accessor.describeMaxLength = this.tableMaxLengths[n2];
            accessor.nullable = this.tableNullables[n2];
            accessor.precision = this.tablePrecisions[n2];
            accessor.scale = this.tablePrecisions[n2];
            accessor.formOfUse = this.tableFormOfUses[n2];
            ++n;
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    static final boolean isInsertSqlStmt(String string) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68);
        }
        return string.trim().toUpperCase().startsWith("INSERT");
    }
}

