/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:18_PDT_2010";

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection oracleConnection) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected OracleTypeCHAR(OracleConnection oracleConnection, int n) {
        super(n);
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n2 = (int)(n == -1 ? (long)cArray.length : Math.min((long)cArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                int n3 = 0;
                while (n3 < n2) {
                    datumArray[n3] = new CHAR(new String(cArray[(int)l + n3 - 1]), this.pickleCharacterSet);
                    ++n3;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n4 = (int)(n == -1 ? (long)blArray.length : Math.min((long)blArray.length - l + 1L, (long)n));
                datumArray = new Datum[n4];
                int n5 = 0;
                while (n5 < n4) {
                    datumArray[n5] = new CHAR(new Boolean(blArray[(int)l + n5 - 1]), this.pickleCharacterSet);
                    ++n5;
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n6 = (int)(n == -1 ? (long)sArray.length : Math.min((long)sArray.length - l + 1L, (long)n));
                datumArray = new Datum[n6];
                int n7 = 0;
                while (n7 < n6) {
                    datumArray[n7] = new CHAR(new Integer(sArray[(int)l + n7 - 1]), this.pickleCharacterSet);
                    ++n7;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n8 = (int)(n == -1 ? (long)nArray.length : Math.min((long)nArray.length - l + 1L, (long)n));
                datumArray = new Datum[n8];
                int n9 = 0;
                while (n9 < n8) {
                    datumArray[n9] = new CHAR(new Integer(nArray[(int)l + n9 - 1]), this.pickleCharacterSet);
                    ++n9;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n10 = (int)(n == -1 ? (long)lArray.length : Math.min((long)lArray.length - l + 1L, (long)n));
                datumArray = new Datum[n10];
                int n11 = 0;
                while (n11 < n10) {
                    datumArray[n11] = new CHAR(new Long(lArray[(int)l + n11 - 1]), this.pickleCharacterSet);
                    ++n11;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n12 = (int)(n == -1 ? (long)fArray.length : Math.min((long)fArray.length - l + 1L, (long)n));
                datumArray = new Datum[n12];
                int n13 = 0;
                while (n13 < n12) {
                    datumArray[n13] = new CHAR(new Float(fArray[(int)l + n13 - 1]), this.pickleCharacterSet);
                    ++n13;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n14 = (int)(n == -1 ? (long)dArray.length : Math.min((long)dArray.length - l + 1L, (long)n));
                datumArray = new Datum[n14];
                int n15 = 0;
                while (n15 < n14) {
                    datumArray[n15] = new CHAR(new Double(dArray[(int)l + n15 - 1]), this.pickleCharacterSet);
                    ++n15;
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    private CHAR getDbCHAR(Datum datum) {
        CHAR cHAR = (CHAR)datum;
        CHAR cHAR2 = null;
        if (cHAR.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
            cHAR2 = cHAR;
        } else {
            try {
                cHAR2 = new CHAR(cHAR.toString(), this.pickleCharacterSet);
            }
            catch (SQLException sQLException) {
                cHAR2 = cHAR;
            }
        }
        return cHAR2;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        super.parseTDSrec(tDSReader);
        try {
            this.length = tDSReader.readShort();
            this.form = tDSReader.readByte();
            this.characterSemantic = this.form & 0x80;
            this.form &= 0x7F;
            this.charset = tDSReader.readShort();
        }
        catch (SQLException sQLException) {
            DatabaseError.throwSqlException(47, "parseTDS");
        }
        if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
            return;
        }
        try {
            this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
        }
        catch (SQLException sQLException) {
            this.pickleNcharCharacterSet = (short)2000;
        }
        this.pickleCharaterSetId = this.pickleNcharCharacterSet;
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        CHAR cHAR = this.getDbCHAR(datum);
        if (this.characterSemantic != 0 && this.form != 2) {
            if (cHAR.getStringWithReplacement().length() > this.length) {
                DatabaseError.throwSqlException(72, "\"" + cHAR.getStringWithReplacement() + "\"");
            }
        } else if (cHAR.getLength() > (long)this.length) {
            DatabaseError.throwSqlException(72, "\"" + cHAR.getStringWithReplacement() + "\"");
        }
        return super.pickle81(pickleContext, cHAR);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.form = objectInputStream.readInt();
        this.charset = objectInputStream.readInt();
        this.length = objectInputStream.readInt();
        this.characterSemantic = objectInputStream.readInt();
        this.pickleCharaterSetId = objectInputStream.readShort();
        this.pickleNcharCharacterSet = objectInputStream.readShort();
        this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        CHAR cHAR = object instanceof CHAR ? (CHAR)object : new CHAR(object, this.pickleCharacterSet);
        return cHAR;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                return super.toDatumArray(object, oracleConnection, l, n);
            }
            datumArray = this.cArrayToDatumArray(object, oracleConnection, l, n);
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CHAR cHAR = null;
        switch (this.form) {
            case 1: 
            case 2: {
                cHAR = new CHAR(byArray, this.pickleCharacterSet);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(byArray, null);
                break;
            }
        }
        if (n == 1) {
            return cHAR;
        }
        if (n == 2) {
            return cHAR.stringValue();
        }
        if (n == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        switch (n) {
            case 1: {
                if (unpickleContext.isNull(this.nullOffset)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
                if (n2 == 9) {
                    unpickleContext.skipBytes(6);
                    return null;
                }
                long l = unpickleContext.readLong();
                if (l == 0L) {
                    unpickleContext.skipBytes(2);
                    unpickleContext.mark();
                } else {
                    unpickleContext.markAndSkip(l);
                }
                byte[] byArray = unpickleContext.readLengthBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n2, map);
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) == 1) {
                    unpickleContext.skipBytes(4);
                    return null;
                }
            }
            case 3: {
                if (n2 == 9) {
                    unpickleContext.skipLengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.readLengthBytes(), n2, map);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.form);
        objectOutputStream.writeInt(this.charset);
        objectOutputStream.writeInt(this.length);
        objectOutputStream.writeInt(this.characterSemantic);
        objectOutputStream.writeShort(this.pickleCharaterSetId);
        objectOutputStream.writeShort(this.pickleNcharCharacterSet);
    }
}

