/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private OracleConnection conn;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:15_PDT_2010";

    public OracleJdbc2SQLInput(Datum[] datumArray, Map map, OracleConnection oracleConnection) {
        this.attributes = datumArray;
        this.map = map;
        this.conn = oracleConnection;
        this.index = 0;
    }

    public ARRAY readARRAY() throws SQLException {
        ARRAY aRRAY;
        block3: {
            aRRAY = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof ARRAY) {
                    aRRAY = (ARRAY)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return aRRAY;
    }

    public Array readArray() throws SQLException {
        return this.readARRAY();
    }

    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream;
        block2: {
            inputStream = null;
            try {
                Datum datum = this.attributes[this.index];
                if (datum == null) break block2;
                inputStream = datum.asciiStreamValue();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return inputStream;
    }

    public BFILE readBFILE() throws SQLException {
        BFILE bFILE;
        block3: {
            bFILE = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof BFILE) {
                    bFILE = (BFILE)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return bFILE;
    }

    public BLOB readBLOB() throws SQLException {
        BLOB bLOB;
        block3: {
            bLOB = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof BLOB) {
                    bLOB = (BLOB)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return bLOB;
    }

    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        block2: {
            bigDecimal = null;
            try {
                if (this.attributes[this.index] == null) break block2;
                bigDecimal = this.attributes[this.index].bigDecimalValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return bigDecimal;
    }

    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream;
        block2: {
            inputStream = null;
            try {
                Datum datum = this.attributes[this.index];
                if (datum == null) break block2;
                inputStream = datum.binaryStreamValue();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return inputStream;
    }

    public Blob readBlob() throws SQLException {
        return this.readBLOB();
    }

    public boolean readBoolean() throws SQLException {
        boolean bl;
        block2: {
            bl = false;
            try {
                if (this.attributes[this.index] == null) break block2;
                bl = this.attributes[this.index].booleanValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return bl;
    }

    public byte readByte() throws SQLException {
        byte by;
        block2: {
            by = 0;
            try {
                if (this.attributes[this.index] == null) break block2;
                by = this.attributes[this.index].byteValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return by;
    }

    public byte[] readBytes() throws SQLException {
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof RAW) {
                    byArray = ((RAW)this.attributes[this.index]).shareBytes();
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return byArray;
    }

    public CHAR readCHAR() throws SQLException {
        CHAR cHAR;
        block3: {
            cHAR = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof CHAR) {
                    cHAR = (CHAR)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return cHAR;
    }

    public CLOB readCLOB() throws SQLException {
        CLOB cLOB;
        block3: {
            cLOB = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof CLOB) {
                    cLOB = (CLOB)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return cLOB;
    }

    public Reader readCharacterStream() throws SQLException {
        Reader reader;
        block2: {
            reader = null;
            try {
                Datum datum = this.attributes[this.index];
                if (datum == null) break block2;
                reader = datum.characterStreamValue();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return reader;
    }

    public Clob readClob() throws SQLException {
        return this.readCLOB();
    }

    public DATE readDATE() throws SQLException {
        DATE dATE;
        block3: {
            dATE = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof DATE) {
                    dATE = (DATE)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return dATE;
    }

    public Date readDate() throws SQLException {
        Date date;
        block2: {
            date = null;
            try {
                if (this.attributes[this.index] == null) break block2;
                date = this.attributes[this.index].dateValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return date;
    }

    public double readDouble() throws SQLException {
        double d;
        block2: {
            d = 0.0;
            try {
                if (this.attributes[this.index] == null) break block2;
                d = this.attributes[this.index].doubleValue();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var4_2 = null;
        ++this.index;
        return d;
    }

    public float readFloat() throws SQLException {
        float f;
        block2: {
            f = 0.0f;
            try {
                if (this.attributes[this.index] == null) break block2;
                f = this.attributes[this.index].floatValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return f;
    }

    public int readInt() throws SQLException {
        int n;
        block2: {
            n = 0;
            try {
                if (this.attributes[this.index] == null) break block2;
                n = this.attributes[this.index].intValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return n;
    }

    public long readLong() throws SQLException {
        long l;
        block2: {
            l = 0L;
            try {
                if (this.attributes[this.index] == null) break block2;
                l = this.attributes[this.index].longValue();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var4_2 = null;
        ++this.index;
        return l;
    }

    public NUMBER readNUMBER() throws SQLException {
        NUMBER nUMBER;
        block3: {
            nUMBER = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof NUMBER) {
                    nUMBER = (NUMBER)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return nUMBER;
    }

    public Object readObject() throws SQLException {
        Datum datum = (Datum)this.readOracleObject();
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(this.map);
            }
            datum.toJdbc();
        }
        return null;
    }

    public Object readOracleObject() throws SQLException {
        Datum datum = this.attributes[this.index++];
        return datum;
    }

    public RAW readRAW() throws SQLException {
        RAW rAW;
        block3: {
            rAW = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof RAW) {
                    rAW = (RAW)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return rAW;
    }

    public REF readREF() throws SQLException {
        REF rEF;
        block3: {
            rEF = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof REF) {
                    rEF = (REF)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return rEF;
    }

    public ROWID readROWID() throws SQLException {
        ROWID rOWID;
        block3: {
            rOWID = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof ROWID) {
                    rOWID = (ROWID)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return rOWID;
    }

    public Ref readRef() throws SQLException {
        return this.readREF();
    }

    public STRUCT readSTRUCT() throws SQLException {
        STRUCT sTRUCT;
        block3: {
            sTRUCT = null;
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof STRUCT) {
                    sTRUCT = (STRUCT)this.attributes[this.index];
                    break block3;
                }
                DatabaseError.throwSqlException(4, null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return sTRUCT;
    }

    public short readShort() throws SQLException {
        long l = this.readLong();
        if (l > 65537L || l < -65538L) {
            DatabaseError.throwSqlException(26, "readShort");
        }
        short s = (short)l;
        return s;
    }

    public String readString() throws SQLException {
        String string;
        block2: {
            string = null;
            try {
                if (this.attributes[this.index] == null) break block2;
                string = this.attributes[this.index].stringValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return string;
    }

    public Struct readStruct() throws SQLException {
        return this.readSTRUCT();
    }

    public Time readTime() throws SQLException {
        Time time;
        block2: {
            time = null;
            try {
                if (this.attributes[this.index] == null) break block2;
                time = this.attributes[this.index].timeValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return time;
    }

    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp;
        block2: {
            timestamp = null;
            try {
                if (this.attributes[this.index] == null) break block2;
                timestamp = this.attributes[this.index].timestampValue();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.index;
        return timestamp;
    }

    public URL readURL() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public boolean wasNull() throws SQLException {
        if (this.index == 0) {
            DatabaseError.throwSqlException(24);
        }
        boolean bl = this.attributes[this.index - 1] == null;
        return bl;
    }
}

